package elaborator.tests;

import java.util.Set;

import elaborator.*;
import elaborator.utils.FileLoader;
import elaborator.utils.FileWriter;

public class Test2 {
	public static void main(String[] args) {

		Receiver receiver = new AdapterSensorsInterface();
		Elaborator elaborator = new Elaborator();
		elaborator.setReceiver(receiver);
		System.out.println("\nRicezione dati...");
		elaborator.receiveData();
		System.out.println("\nRicevuto "+receiver.getTemps()[0]+" "+receiver.getTemps()[1]);
		
		System.out.println("\n"+receiver.getDiameter()+"\n");
		Set<Double> keys = receiver.getComposition().keySet();
		for (Double key : keys) {
			String value = receiver.getComposition().get(key);	
			System.out.println(key+" "+ value);
		}
		
		Sender sender = new FileWriter();
		elaborator.setSender(sender);
		elaborator.sendData();
		System.out.println("\nSalvataggio dati...");
		sender.writeDatabase();
		
		System.out.println("\nSalvato in database/"+receiver.getPlanetName()+".txt");
		
		System.out.println("\nTest Lettura Database per Urano...");
		
		Receiver receiver2 = new FileLoader("Urano");
//		receiver2.getPlanet("Urano");
		elaborator.setReceiver(receiver2);
		System.out.println("\nRicezione nuovi dati...");
		elaborator.receiveData();
		
System.out.println("\nRicevuto "+receiver2.getTemps()[0]+" "+receiver2.getTemps()[1]);
		
		System.out.println("\n"+receiver2.getDiameter()+"\n");
		Set<Double> keys2 = receiver2.getComposition().keySet();
		for (Double key : keys2) {
			String value = receiver2.getComposition().get(key);	
			System.out.println(key+" "+ value);
		}
		
		
	}
}
